import React, { useState, useRef, useEffect } from 'react';
import Popup from '@crm/components/dist/lego2/Popup';
import Button from '@crm/components/dist/lego2/Button';
import { mergeAllRefs } from '@yandex-lego/components/lib/mergeRefs';
import { ButtonWithPopupProps } from './ButtonWithPopup.types';

export const ButtonWithPopup: React.FC<ButtonWithPopupProps> = ({
  popupProps,
  visible,
  onOutsideClick,
  onVisibleChange,
  onClick,
  children,
  innerRef,
  button = <Button>...</Button>,
  ...props
}) => {
  const anchorRef = useRef<HTMLElement>(null);
  const [isVisible, setVisible] = useState(visible);

  const handlePopUpVisibleChange = (visible: boolean) => {
    setVisible(visible);
    if (onVisibleChange) {
      onVisibleChange(visible);
    }
  };

  const handleMoreButtonClick = () => {
    const nextVisible = !isVisible;

    setVisible(nextVisible);
    handlePopUpVisibleChange(nextVisible);
    if (onClick) {
      onClick();
    }
  };

  const handleOutsideClick = () => {
    setVisible(false);
    handlePopUpVisibleChange(false);
    if (onOutsideClick) {
      onOutsideClick();
    }
  };

  useEffect(() => {
    handlePopUpVisibleChange(Boolean(visible));
  }, [visible]);

  return (
    <React.Fragment>
      {React.cloneElement(button, {
        ...props,
        innerRef: mergeAllRefs(anchorRef, innerRef),
        onClick: handleMoreButtonClick,
      })}
      <Popup
        view="default"
        onOutsideClick={handleOutsideClick}
        visible={isVisible}
        anchor={anchorRef}
        target="anchor"
        {...popupProps}
      >
        {children}
      </Popup>
    </React.Fragment>
  );
};
