import React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import { RollerWithPopup } from './RollerWithPopup';

export default {
  title: 'Roller/RollerWithPopup',
  component: RollerWithPopup,
};

const ARRAY_LENGTH = 10;

export const Default = () => {
  return (
    <RollerWithPopup
      moreButtonProps={{
        element: <Button size="l">...</Button>,
      }}
      popupProps={{
        element: () => <div style={{ backgroundColor: 'red', height: 50, width: 100 }} />,
      }}
    >
      {Array.from({ length: ARRAY_LENGTH }).map((item, index) => (
        <Button
          key={index}
          view="default"
          size="l"
          style={{ minWidth: 100 }}
          onClick={() => {
            window.alert(`Button number clicked: ${index + 1}`);
          }}
        >
          {index + 1}
        </Button>
      ))}
    </RollerWithPopup>
  );
};
