import React, { FunctionComponent } from 'react';
import { ImperativePopupProps } from '@crm/components/dist/lego2/Popup';
import { ClickableAnchor } from './ButtonWithPopup';
import { RollerProps } from '../Roller.types';

export interface RollerWithPopupProps<T>
  extends Pick<RollerProps, 'updateKey' | 'onHiddenComponentsChange'> {
  className?: string;
  rollerClassNames?: {
    containerClassName?: string;
    className?: string;
  };
  moreButtonProps?: MoreButtonProps;
  popupProps?: PopUpProps<T>;
}

export interface PopUpProps<T> extends ImperativePopupProps {
  className?: string;
  containerClassName?: string;
  visible?: boolean;
  onVisibleChange?: (visible: boolean) => void;
  onOutsideClick?: () => void;
  element?: FunctionComponent<T>;
}

export interface MoreButtonProps {
  element?: React.ReactElement<ClickableAnchor>;
  onClick?: () => void;
}
