import React from 'react';
import { Route } from 'react-router-dom';
import Button, { ButtonProps } from '@crm/components/dist/lego2/Button';

interface Props extends ButtonProps {
  to: string;
}

const RouterLink: React.FC<Props> = (props) => {
  const { to, ...other } = props;

  return (
    <Route>
      {(routeProps) => <Button onClick={() => routeProps.history.push(to)} {...other} />}
    </Route>
  );
};

export default RouterLink;
