import React from 'react';
import { Route, Link, RouteChildrenProps } from 'react-router-dom';
import cx from 'classnames';

export interface RouterLinkProps {
  exact?: boolean;
  to: string;
  className?: string;
  activeClassName?: string;
  customMatch?: (routeProps: RouteChildrenProps) => boolean;
  title?: string;
  target?: string;
}

const RouterLink: React.FC<RouterLinkProps> = props => {
  const { to, exact, activeClassName = '', className, customMatch, ...other } = props;

  return (
    <Route path={to} exact={exact}>
      {routeProps => (
        <Link
          className={cx(className, {
            [activeClassName]:
              typeof customMatch === 'function' ? customMatch(routeProps) : routeProps.match,
          })}
          to={to}
          {...other}
        />
      )}
    </Route>
  );
};

export default RouterLink;
