import * as React from 'react';
import cx from 'classnames';
import css from './SaasHighlight.scss';

interface Props {
  html: string;
  className?: string;
}

const SaasHighlight = ({ html, className, ...other }: Props) => (
  <span className={cx(className, css.b)} {...other} dangerouslySetInnerHTML={{ __html: html }} />
);

export default SaasHighlight;
