import React from 'react';
import PropTypes from 'prop-types';
import css from './styles.modules.scss';

const propTypes = {
  range: PropTypes.array, // select range
  selectClass: PropTypes.string,
  value: PropTypes.string,
};

const defaultProps = {
  selectClass: css.select,
};

export default class Select extends React.Component {
  render() {
    const { value, range } = this.props;

    if (!range) {
      return <span className={this.props.className}>{value}</span>;
    }

    return (
      <span className={this.props.className}>
        {value.substring(0, range[0])}
        <span className={this.props.selectClass}>{value.substring(range[0], range[1])}</span>
        {value.substring(range[1])}
      </span>
    );
  }
}

Select.propTypes = propTypes;
Select.defaultProps = defaultProps;
