import React, { FC, useRef } from 'react';
import { Bubble } from 'components/Bubble';
import { useFocus } from 'utils/hooks/useFocus';
import { UserLink } from 'components/UserLink';
import { SelectedBubbleUserProps } from './SelectedBubbleUser.types';
import css from './SelectedBubbleUser.module.css';

export const SelectedBubbleUser: FC<SelectedBubbleUserProps> = (props) => {
  const { user, ...restProps } = props;

  const bubbleRef = useRef<HTMLElement>();
  const isFocused = useFocus(bubbleRef);

  return (
    <Bubble
      {...restProps}
      enableFocusStyles={false}
      innerRef={(instance) => (bubbleRef.current = instance)}
      view={isFocused ? 'default' : 'clear'}
    >
      <UserLink
        user={user}
        isTooltipDisabled
        isDisabled
        className={css.SelectedBubbleUser__userLink}
      />
    </Bubble>
  );
};
