/* eslint-disable camelcase */

import React from 'react';
import Avatar from 'components/Avatar';
import Link from '@crm/components/dist/lego2/Link';
import CopyButton from 'lego/components/CopyButton';
import cx from 'classnames';
import PropTypes from 'prop-types';
import { createStaffUrl } from 'utils/createStaffUrl';
import Icon from 'lego/components/Icon';
import Name from 'components/Name';
import css from './StaffCard.scss';

const StaffCard = (props) => {
  const { user, className } = props;
  const {
    login,
    group = {},
    office,
    crm_email,
    name,
    position,
    crm_position = '\u2014',
    phones = {},
    gap,
  } = user;

  return (
    <div className={cx(css.b, className)}>
      <div className={css.b__group}>{group.name}</div>
      <div className={css.b__content}>
        <div className={css.b__avatar}>
          <Avatar user={user} />
        </div>
        <div className={css.b__info}>
          <div className={css.b__name}>
            <Link href={createStaffUrl(login)} target="_blank" theme="black">
              <Name name={name} />
            </Link>
          </div>
          <div>{position}</div>
          <div className={css.b__crm}>
            {crm_position && (
              <div title="CRM Роль">
                <Icon type="svg" icon="space" />
                &nbsp;
                <span>{crm_position}</span>
              </div>
            )}
            {crm_email && (
              <div title={`Почта ${crm_email.label}`}>
                <Icon pack={Icon.PACKS.MATERIAL} icon="mail" />
                &nbsp;
                <span>{crm_email.value}</span>
                <CopyButton copy={crm_email.value} size="xs" view="clear" />
              </div>
            )}
            {phones.work && (
              <div title="Добавочный номер">
                <Icon pack={Icon.PACKS.MATERIAL} icon="phone" />
                &nbsp;
                <span>{phones.work}</span>
              </div>
            )}
          </div>
        </div>
      </div>
      <div className={css.b__location}>
        <Icon pack={Icon.PACKS.MATERIAL} icon="location_on" />
        {office}
      </div>
      {gap && (
        <div className={css.b__gap} style={{ background: gap.color }}>
          {gap.time}
          &nbsp;
          {gap.name}
        </div>
      )}
    </div>
  );
};

StaffCard.defaultProps = {
  user: undefined,
  className: undefined,
};

StaffCard.propTypes = {
  user: PropTypes.instanceOf(Object),
  className: PropTypes.string,
};

export default StaffCard;
