import React, { FC } from 'react';
import Avatar from 'components/Avatar';
import Link from '@crm/components/dist/lego2/Link';
import { Text } from '@crm/components/dist/lego2/Text';
import CopyButton from 'lego/components/CopyButton';
import Lego2Icon from '@crm/components/dist/lego2/Icon';
import { createStaffUrl } from 'utils/createStaffUrl';
import { isExternalUser } from 'utils/isExternalUser';
import { MGStaffCardProps } from './MGStaffCard.types';
import css from './MGStaffCard.module.css';

export const MGStaffCard: FC<MGStaffCardProps> = (props) => {
  const { user } = props;

  // fake user
  if (!user.login) {
    return null;
  }

  return (
    <div className={css.MGStaffCard}>
      <div className={css.MGStaffCard__mainInfo}>
        <Avatar user={user} className={css.MGStaffCard__avatar} style={{ borderRadius: 8 }} />
        <div className={css.MGStaffCard__mainInfoText}>
          {user.name && (
            <Link
              className={css.MGStaffCard__nameLink}
              href={createStaffUrl(user.login)}
              target="_blank"
              theme="black"
            >
              <Text weight="medium" className={css.MGStaffCard__name} typography="body-short-xl">
                <Text weight="medium" color="alert">
                  {user.name[0]}
                </Text>
                {user.name.slice(1)}
              </Text>
            </Link>
          )}
          {!isExternalUser(user) && Boolean(user.group?.name) && (
            <Text typography="body-long-m">{user.group!.name}</Text>
          )}
          {!isExternalUser(user) && <Text typography="body-long-m">{user.position}</Text>}
        </div>
      </div>
      <div className={css.MGStaffCard__additionalInfo}>
        {!isExternalUser(user) && Boolean(user.crm_position) && (
          <div className={css.MGStaffCard__additionalInfoRow}>
            <Lego2Icon svgSize="ml" svg="space" className={css.MGStaffCard__icon} />
            <Text typography="body-long-m">{user.crm_position}</Text>
          </div>
        )}
        <div className={css.MGStaffCard__additionalInfoRow}>
          <Lego2Icon svgSize="ml" className={css.MGStaffCard__icon} svg="account" />
          <Text typography="body-long-m">{user.login}</Text>
          <CopyButton
            className={css.MGStaffCard__copyButton}
            iconProvider={(cls) => <Lego2Icon className={cls} svg="copy2" svgSize="ms" />}
            copy={user.login}
            size="xs"
            view="clear"
          />
        </div>
        {!isExternalUser(user) && Boolean(user.crm_email?.value) && (
          <div className={css.MGStaffCard__additionalInfoRow}>
            <Lego2Icon svgSize="ml" className={css.MGStaffCard__icon} svg="mailOutline" />
            <Text typography="body-long-m">{user.crm_email!.value}</Text>
            <CopyButton
              className={css.MGStaffCard__copyButton}
              iconProvider={(cls) => <Lego2Icon className={cls} svg="copy2" svgSize="ms" />}
              copy={user.crm_email?.value || ''}
              size="xs"
              view="clear"
            />
          </div>
        )}
        {!isExternalUser(user) && Boolean(user.phones?.work) && (
          <div className={css.MGStaffCard__additionalInfoRow}>
            <Lego2Icon svgSize="ml" className={css.MGStaffCard__icon} svg="call" />
            <Text typography="body-long-m">{user.phones?.work}</Text>
          </div>
        )}
        {!isExternalUser(user) && Boolean(user.office) && (
          <div className={css.MGStaffCard__additionalInfoRow}>
            <Lego2Icon svgSize="ml" className={css.MGStaffCard__icon} svg="location" />
            <Text typography="body-long-m">{user.office}</Text>
          </div>
        )}
      </div>
    </div>
  );
};
