/* eslint-disable camelcase */

import React from 'react';
import PropTypes from 'prop-types';
import Avatar from 'components/Avatar';
import ToolTip from 'lego/components/ToolTip';
import { UserStatusIconByUser } from 'components/UserStatusIconByUser';
import Name from 'components/Name';
import Icon from 'lego/components/Icon';
import { StaffCard } from './StaffCard';

const StaffCardWidget = (props) => {
  const { user, className, theme, crmPosition, showPhoneStatus, ...other } = props;

  if (!user) {
    return null;
  }

  const { name, crm_position, binded } = user;

  let formattedName = name;
  if (crmPosition && crm_position) {
    formattedName = `${name} (${crm_position})`;
  }

  let inline = null;
  if (theme === StaffCardWidget.THEME.YANDEX) {
    inline = <Name className={className} name={formattedName} />;
  } else if (theme === StaffCardWidget.THEME.AVATAR) {
    inline = <Avatar user={user} {...other} theme="round" />;
  } else {
    inline = formattedName;
  }

  if (binded) {
    inline = (
      <>
        <Icon pack={Icon.PACKS.MATERIAL} icon="star" title="Привязанный менеджер" />
        &nbsp;
        {inline}
      </>
    );
  }

  if (showPhoneStatus) {
    inline = (
      <>
        {inline}
        <UserStatusIconByUser userId={user.id} />
      </>
    );
  }

  return (
    <ToolTip
      autoZIndex
      padding="s"
      showDelay={300}
      hideDelay={300}
      tooltip={<StaffCard user={user} />}
      stopPropagation
    >
      {inline}
    </ToolTip>
  );
};

StaffCardWidget.THEME = {
  YANDEX: 'yandex',
  DEFAULT: 'default',
  AVATAR: 'avatar',
};

StaffCardWidget.propTypes = {
  user: PropTypes.shape({
    login: PropTypes.string,
    name: PropTypes.string,
    crm_position: PropTypes.string,
    binded: PropTypes.bool,
  }),
  theme: PropTypes.string,
  className: PropTypes.string,
  crmPosition: PropTypes.bool,
  showPhoneStatus: PropTypes.bool,
};

StaffCardWidget.defaultProps = {
  user: undefined,
  theme: StaffCardWidget.THEME.DEFAULT,
  className: undefined,
  crmPosition: false,
  showPhoneStatus: false,
};

export default StaffCardWidget;
