import { jsonApiCall } from 'api/common';
import { FieldDataAny } from 'types/api/form/Form';
import { TableController } from 'components/Table/services/TableController';
import { Link } from 'types/api/form/Fields/Link';
import { OpportunityFormValues } from 'modules/issues/components/Forms/CreateForm/OpportunityForm/OpportunityForm.types';

const getNameFromFields = (fields: FieldDataAny[]) => {
  const field = fields.find((el) => el.id === 'name')?.data as Link;
  if (!field) return '';

  return field.text.value ?? '';
};

export const mapIdsToSelectedItems = (ids: string[], controller: TableController) => {
  return ids.map((id) => {
    const fields = controller.findRowById(id)?.fields;
    if (!fields) return { id, name: '' };

    const name = getNameFromFields(fields);
    return { id, name };
  });
};

export const createNewOpportunity = async (values: OpportunityFormValues) => {
  const data = {
    accountId: values.account.id,
    name: values.name,
    opportunitySourceId: Number(values.opportunitySource),
    ownerId: values.owner?.id,
  };

  const res = await jsonApiCall({
    url: `/issues/create`,
    type: 'POST',
    global: false,
    data: {
      data,
      context: { module: 'opportunity' },
    },
  });

  return Object.keys(res.storage.issues)[0];
};
