import React from 'react';
import { SuggestGrid } from '../SuggestGrid';
import { selectedItems } from './mocks/SuggestGrid.examples.config';

import { worker } from './mocks/browser';

export default {
  title: 'SuggestGrid',
  component: SuggestGrid,
  argTypes: {
    provider: { control: null },
    onChange: { action: 'onChange' },
  },
  args: {
    value: selectedItems,
    provider: '/form',
  },
  decorators: [
    (Story) => {
      // Reset request handlers added in individual stories.
      worker?.start();
      worker?.resetHandlers();
      return <Story />;
    },
  ],
};

export const suggestGrid = (args) => <SuggestGrid {...args} />;
