import { Form } from 'types/api/form/Form';

const data = Array(4)
  .fill('')
  .map((_, id) => ({
    id: id.toString(),
    fields: [
      { type: 'Text', id: 'id', data: { value: id.toString() } },
      { type: 'Link', id: 'name', data: { link: `#${id}`, text: { value: `Name ${id}` } } },
      { type: 'Text', id: 'products', data: { value: `Products ${id}` } },
      { id: 'plannedDate', type: 'Empty' },
    ],
  }));

export const form: Form = {
  meta: {
    fieldsVisibility: ['id', 'name', 'products', 'plannedDate'],
    fields: [
      {
        id: 'id',
        title: 'id',
        sortable: false,
        isPinned: false,
        type: 'Text',
        access: 1,
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'name',
        title: 'Название',
        sortable: false,
        isPinned: false,
        type: 'Link',
        access: 1,
        isFieldsUpdateNeeded: false,
      },
      {
        id: 'products',
        title: 'Продукты',
        sortable: false,
        isPinned: false,
        type: 'Text',
        access: 1,
        isFieldsUpdateNeeded: false,
      },
      {
        options: { valueType: 'DateTime' },
        id: 'plannedDate',
        title: 'Плановая дата завершения',
        sortable: false,
        isPinned: false,
        type: 'DateTime',
        access: 1,
        isFieldsUpdateNeeded: false,
      },
    ],
    title: 'Привяжите сделки',
  },
  data,
};

export const selectedItems = [
  { id: '1', name: 'Name 1' },
  { id: '3', name: 'Name 3' },
];
