import React from 'react';
import Tags from 'lego/components/Tags';
import Button from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import { ModalGrid } from './ModalGrid';
import { SuggestGridProps } from './SuggestGrid.types';
import css from './SuggestGrid.module.css';
import { Tag } from './Tag';

const getKey = (item) => item.id;

export const SuggestGrid = (props: SuggestGridProps) => {
  const { provider, value, onChange, title, account } = props;
  const [visible, setVisible] = React.useState(false);

  const openModal = () => setVisible(true);

  const handleDelete = (id) => {
    onChange(value.filter((el) => el.id !== id));
  };

  const handleSave = (value) => {
    onChange(value);
    setVisible(false);
  };

  return (
    <div className={css.SuggestGrid}>
      {value.length ? (
        <div className={css.SuggestGrid__tags}>
          <Tags
            items={value}
            getKey={getKey}
            onDelete={handleDelete}
            component={Tag}
            injectAfter={
              <Button
                className={css.SuggestGrid__editButton}
                view="clear"
                icon={(cls) => <Icon size="xs" svg="pencil" className={cls} />}
                onClick={openModal}
                data-testid="suggest-grid-edit"
              />
            }
          />
        </div>
      ) : (
        <Button onClick={openModal} data-testid="suggest-grid-edit">
          Выбрать
        </Button>
      )}

      <ModalGrid
        provider={provider}
        selected={value}
        visible={visible}
        onClose={() => setVisible(false)}
        onSave={handleSave}
        title={title}
        account={account}
      />
    </div>
  );
};
