import React from 'react';
import { PopupItemUser } from 'components/PopupItemUser';
import { SelectedBubbleUser } from 'components/SelectedBubbleUser';
import { SuggestWithTags } from './SuggestWithTags';

const renderItem = (user, { isSelected }) => {
  return (
    <PopupItemUser
      user={{ id: user.id, name: user.name, login: user.login }}
      isSelected={isSelected}
    />
  );
};

const renderSelectedBubble = (user, { onDelete }) => {
  return <SelectedBubbleUser user={user} onDelete={onDelete} canDelete />;
};

export const SuggestUser: typeof SuggestWithTags = (props) => {
  return <SuggestWithTags {...props} renderItem={renderItem} renderBubble={renderSelectedBubble} />;
};
