import React, { useState } from 'react';
import { rest } from 'msw';
import { SuggestWithTags } from './SuggestWithTags';
import { SuggestUser } from './SuggestUser';
import { accountList, cityList } from './__mocks__';

export default {
  title: 'SuggestWithTags',
  component: SuggestWithTags,
};

const StatefulSuggestWithTags = (props) => {
  const [value, setValue] = useState([]);
  return <SuggestWithTags {...props} value={value} onChange={setValue} />;
};
export const suggestWithTags = (args) => <StatefulSuggestWithTags {...args} />;
suggestWithTags.args = {
  provider: '/list',
};
suggestWithTags.parameters = {
  msw: {
    handlers: [
      rest.get(`*/list`, (_req, res, ctx) => {
        return res(ctx.json(cityList));
      }),
    ],
  },
};

const StatefulSuggestUser = (props) => {
  const [value, setValue] = useState([]);
  return <SuggestUser {...props} value={value} onChange={setValue} />;
};
export const suggestUser = (args) => <StatefulSuggestUser {...args} />;
suggestUser.args = {
  provider: '/dicts/liftUserManagers',
};
suggestUser.parameters = {
  msw: {
    handlers: [
      rest.get(`*/dicts/liftUserManagers`, (_req, res, ctx) => {
        return res(ctx.json(accountList));
      }),
    ],
  },
};
