import { baseCallApi } from 'api/common';
import { GeneralSuggestItem } from 'types/api/form/UserFilter';

export const getSuggestData = (url: string, text?: string) => {
  return baseCallApi({
    url,
    data: {
      text,
    },
    global: false,
  });
};

export const mapToDictionary = (
  items: GeneralSuggestItem[],
): Record<string | number, GeneralSuggestItem> => {
  const dict = {};
  for (const item of items) {
    dict[item.id!] = item;
  }
  return dict;
};
