import { useEffect, useState } from 'react';
import { useDebounce } from 'utils/hooks/useDebounce';
import { GeneralSuggestItem } from 'types/api/form/UserFilter';
import { getSuggestData } from './SuggestWithTags.utils';

export const DEBOUNCE_DELAY = 500;

interface useSuggestProps {
  text: string;
  url?: string;
  mapper: (data: unknown) => GeneralSuggestItem[];
  isEditing: boolean;
  debounceDelay?: number;
}

export const useSuggest = (props: useSuggestProps) => {
  const { text, url = '', mapper, isEditing, debounceDelay = DEBOUNCE_DELAY } = props;
  const debouncedText = useDebounce(text, debounceDelay);
  const [isLoading, setLoading] = useState(false);
  const [items, setItems] = useState<GeneralSuggestItem[]>([]);

  useEffect(() => {
    if (!isEditing) {
      return;
    }
    setLoading(true);
    getSuggestData(url, debouncedText)
      .then((newItems) => {
        setItems(mapper(newItems));
      })
      .finally(() => {
        setLoading(false);
      });
  }, [debouncedText, isEditing, mapper, url]);

  return { isLoading, items };
};
