import { get, jsonApiCall } from 'api/common';
import { AppModuleString } from 'modules/requestForm2';
import Bluebird from 'bluebird';
import { InternalIssueResponse } from './SupportChatIssue.types';

export const getInternalIssueId = (sourceIssueId: number): Bluebird<InternalIssueResponse> =>
  get({ url: `/issues/oneAndHalfLine/${sourceIssueId}` });

export const createInternalIssue = (sourceIssueId: number): Bluebird<InternalIssueResponse> =>
  jsonApiCall({
    url: '/issues/oneAndHalfLine/create',
    data: {
      data: {
        sourceIssueId,
      },
      context: {
        module: AppModuleString.Ticket,
        action: 'createOneAndHalfLine',
      },
    },
  });
