type Validator = () => string | boolean;
export type ValidatorCollection = Validator[];

export interface Meta {
  [k: string]: string;
}

export interface ChatWidgetConfig {
  iframeUrl: string;
  iframeUrlParams: { build: string };
  theme: string;
  popupTargetNode: HTMLElement;
  autocloseable: boolean;
}

export interface SupportChatWidgetProps {
  className?: string;
  guid?: string;
  validator?: () => string | boolean;
  meta?: Meta;
  validators?: ValidatorCollection;
  access?: number;
  fieldProps?: Object;
}
