import React, { FC, useEffect, useRef } from 'react';
import ToolTip from '@crm/components/dist/lego2/Tooltip';
import css from './Tooltip.module.css';
import { TooltipProps } from './Tooltip.types';

export const Tooltip: FC<TooltipProps> = ({ anchor, message, onClose }) => {
  const container = useRef<Element>();

  const handleOutsideClick = (event: MouseEvent) => {
    const eventPath = event.composedPath();
    if (container.current && !eventPath.includes(container.current)) {
      onClose();
    }
  };
  useEffect(() => {
    window.addEventListener('click', handleOutsideClick);
    return () => {
      window.removeEventListener('click', handleOutsideClick);
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  return (
    <div>
      <ToolTip
        // @ts-ignore next-line-disable
        innerRef={container}
        zIndex={100}
        hasTail
        direction="bottom-left"
        view="default"
        anchor={anchor}
        visible
      >
        <div className={css.b__tooltipBody}>{message}</div>
      </ToolTip>
    </div>
  );
};
