import React, { FC } from 'react';
import Access from 'utils/Access';

export const withCheckAccess = <T extends { access?: number }>(WC: FC<T>) => {
  const withCheckAccess: FC<T> = (props) => {
    if (Access.isEdit(props.access)) {
      return <WC {...props} />;
    }
    return null;
  };

  return withCheckAccess;
};
