import React, { FC, useEffect, useState } from 'react';
import { fetchGuidCollection } from '../../utils/guidComTypeMap';
import { SupportChatWidgetProps } from '../../SupportChatWidget.types';
import { WithLoadGuidsProps } from './withLoadGuids.types';
import { GUID_EMPTY_MESSAGE, COMTYPE_EMPTY_MESSAGE } from '../../SupportChatWidget.constants';

export const withLoadGuids = (WC: FC<SupportChatWidgetProps>) => {
  const WithLoadGuids: FC<WithLoadGuidsProps> = (props) => {
    const [guid, setGuid] = useState<string | undefined>();
    const [loading, setLoading] = useState(true);
    const validator = () => {
      if (!props.comType) {
        return COMTYPE_EMPTY_MESSAGE;
      }
      if (!guid) {
        return GUID_EMPTY_MESSAGE;
      }
      return true;
    };
    useEffect(() => {
      fetchGuidCollection(props.url)
        .then((collection) => {
          const guid = props.comType && collection[props.comType.toLowerCase()];
          setGuid(guid);
          setLoading(false);
        })
        .catch((error) => {
          throw new Error(error);
        });
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);
    const validators = Array.isArray(props.validators)
      ? [validator, ...props.validators]
      : props.validators;
    const unionProps = { ...props, guid, validators };

    if (loading) {
      return null;
    }

    return <WC {...unionProps} />;
  };

  return WithLoadGuids;
};
