export const chatWidgetInit = (popupTargetNode) => {
  if (window.chatWidget) {
    window.chatWidget.popup.params.targetNode = popupTargetNode;
  }
  if (!window.chatWidget) {
    try {
      window.chatWidget =
        window.Ya &&
        window.Ya.ChatWidget &&
        new window.Ya.ChatWidget({
          iframeUrl: 'https://yandex.ru/chat',
          iframeUrlParams: { build: 'chamb' },
          theme: 'hidden',
          popupTargetNode: popupTargetNode,
          autocloseable: false,
        });
    } catch (e) {
      throw new Error(e);
    }
  }
};
