import { get } from 'api/common';
import isEmpty from 'lodash/isEmpty';

interface GuidCollection {
  [k: string]: string;
}

let guidCollection = {};

export const fetchGuidCollection = (url: string = '/supportChat'): Promise<GuidCollection> => {
  if (!isEmpty(guidCollection)) {
    return Promise.resolve(guidCollection);
  }
  return get({ url }).then((data) => {
    for (let [key, value] of Object.entries(data)) {
      guidCollection[key.toLowerCase()] = value;
    }
    return guidCollection;
  });
};
