import React, { FC, memo, useContext } from 'react';
import cx from 'classnames';
import isEqual from 'lodash/isEqual';
import { CellProps } from './Cell.types';
import { wholeCellComponents } from './Cells';
import themes from './themes';
import { themeContext } from '../../themes';

const Cell: FC<CellProps> = memo(
  (props) => {
    const theme = useContext(themeContext);
    const css = themes[theme] || themes.default;
    const { cell, className, access, options } = props;
    const Cell = wholeCellComponents[cell.type] || wholeCellComponents.Unknown;

    return (
      <div className={cx(css.Cell, className)}>
        <Cell options={options} access={access} cell={cell} />
      </div>
    );
  },
  (prevProps, nextProps) => {
    return isEqual(prevProps.cell.data, nextProps.cell.data);
  },
);

export default Cell;
