import React, { FC } from 'react';
import cx from 'classnames';
import css from './CellType.module.css';
import { CellTypeProps } from './CellType.types';

/**
 * Обертка для верстки каждой ячейки таблицы
 */
export const CellType: FC<CellTypeProps> = (props) => {
  const { alignText = 'left' } = props;
  const className = cx(css.CellType, css[`CellType_alignText_${alignText}`]);

  return <div className={className}>{props.children}</div>;
};
