import React, { ReactNode, FC } from 'react';
import { CellType } from '../../CellType';
import { ListCellProps } from './ListCell.types';
import { innerCellComponents } from '../Simple';
import { Unknown } from '../Simple/UnknownCell';

// можно делать лучше https://st.yandex-team.ru/CRM-14814
const withoutComma = new Set(['Diff', 'Button', 'RowAction', 'Tag']);

export const ListCell: FC<ListCellProps> = (props) => {
  const type = props.cell.data[0].type;
  return (
    <CellType>
      {props.cell.data
        .map<ReactNode>((cell, index) => {
          // Берем не весь компонент ячейки, а внутреннюю верстку
          const Component = innerCellComponents[cell.type] || Unknown;
          return <Component access={props.access} key={`${cell.type}:${index}`} cell={cell} />;
        })
        .reduce((prev, current) => {
          if (withoutComma.has(type)) {
            return [prev, current];
          }

          return [prev, ', ', current];
        })}
    </CellType>
  );
};
