import React, { FC } from 'react';
import { Text } from '@crm/components/dist/lego2/Text';
import LegoLink from '@crm/components/dist/lego2/Link';
import getRoutingRoot from 'utils/getRoutingRoot';
import { ToolTipWrapper } from '@crm/components/dist/lego2/Tooltip';
import css from './Account.module.css';
import { AccountCellProps } from './AccountCell.types';
import { AccountTooltip } from './AccountTooltip';

export const Account: FC<AccountCellProps> = ({ cell }) => {
  const { id, name, type } = cell.data;

  return (
    <>
      <div className={css.Account}>
        <LegoLink href={`${getRoutingRoot()}/account/${id}`} target="_blank" rel="noopener">
          <ToolTipWrapper
            className={css.Account__popup}
            content={<AccountTooltip {...cell.data} />}
            closeDelay={300}
            hasTail={false}
            keepMounted
          >
            <Text
              data-testid="grid-cell-account-name"
              className={css.Account_name}
              typography="body-long-m"
            >
              {name}
            </Text>
          </ToolTipWrapper>
        </LegoLink>
        <Text typography="body-long-s" color="secondary">
          {type}
        </Text>
      </div>
    </>
  );
};
