import React from 'react';
import { rest } from 'msw';
import { AccountCell } from './AccountCell';
import { mockedInfo, mockedProps } from './__mocks__';

export default {
  title: 'Grid/AccountCell',
  component: AccountCell,
};

export const Default = (args) => <AccountCell {...args} />;

Default.parameters = {
  msw: {
    handlers: [
      rest.get(`*/view/account/shortInfo/*`, (_req, res, ctx) => {
        return res(ctx.json(mockedInfo));
      }),
    ],
  },
};

Default.args = mockedProps;
