import React, { FC, useContext } from 'react';
import { RowIdContext } from 'components/Table/Row/Row';
import Access from 'utils/Access';
import css from './Button.module.css';
import { ButtonProps } from './Button.types';
import { adapter } from './adapter';

export const Button: FC<ButtonProps> = ({ cell }) => {
  const rowId = useContext(RowIdContext);
  const ButtonComponent = adapter[cell.data.type];
  if (ButtonComponent) {
    return (
      <div className={css.b}>
        <ButtonComponent
          disabled={!Access.isEdit(cell.data.access)}
          button={cell.data}
          rowId={rowId}
        />
      </div>
    );
  }
  return null;
};
