import React, { FC } from 'react';
import { useEditingService } from 'components/Table/hoc';
import Icon from '@crm/components/dist/lego2/Icon';
import cx from 'classnames';
import css from '../../Button.module.css';
import { EditButtonProps } from './EditButton.types';

export const EditButton: FC<EditButtonProps> = ({ rowId }) => {
  const { editRow } = useEditingService();
  const handleClick = () => {
    editRow(rowId);
  };

  return (
    <div
      data-testid="editRowButton"
      className={cx(css.b__button, css.b__buttonEdit)}
      onClick={handleClick}
    >
      <Icon size="m" svg="writeEdit" />
    </div>
  );
};
