import React, { FC } from 'react';
import { useEditingService } from 'components/Table/hoc';
import Icon from '@crm/components/dist/lego2/Icon';
import cx from 'classnames';
import css from '../../Button.module.css';
import { RemoveButtonProps } from './RemoveButton.types';

export const RemoveButton: FC<RemoveButtonProps> = ({ rowId, disabled }) => {
  const { removeRow } = useEditingService();

  const handleClick = () => {
    if (!disabled) {
      removeRow(rowId);
    }
  };

  const className = cx(css.b__button, css.b__buttonRemove, { [css.b__button_disabled]: disabled });

  return (
    <div data-testid="removeRowButton" className={className} onClick={handleClick}>
      <Icon size="m" svg="mainToolbarDelete" />
    </div>
  );
};
