import React, { FC, useState, useEffect } from 'react';
import { post } from 'api/common';
import CheckboxComponent from '@crm/components/dist/lego2/Checkbox';
import { CheckboxCellProps } from './CheckboxCell.types';

export const Checkbox: FC<CheckboxCellProps> = ({ cell }) => {
  const [checked, setChecked] = useState(false);
  const [disabled, setDisabled] = useState(false);
  const { value, url } = cell.data;

  const handleCheck = (value) => {
    if (url) {
      setDisabled(true);
      post({ url, data: { value } })
        .then((res) => setChecked(res.value))
        .finally(() => {
          setDisabled(false);
        });
    }
  };

  useEffect(() => {
    setChecked(value);
  }, []);
  return (
    <CheckboxComponent disabled={disabled} size="m" checked={checked} onChange={handleCheck} />
  );
};
