import React, { FC } from 'react';
import { UnknownCell } from '../UnknownCell';
import { CustomViewProps } from './CustomViewCell.types';
import { nameToViewMap } from './Views';

export const CustomView: FC<CustomViewProps> = ({ cell, options }) => {
  const ViewComponent = nameToViewMap[cell.data.viewName];
  if (!ViewComponent) {
    return <UnknownCell />;
  }
  return <ViewComponent options={options} cell={cell} />;
};
