import React, { FC } from 'react';
import Link from '@crm/components/dist/lego2/Link';
import getRoutingRoot from 'utils/getRoutingRoot';
import { Text } from '@crm/components/dist/lego2/Text';
import css from './TicketShortInfo.module.css';
import { TicketShortInfoProps } from './TicketShortInfo.types';

export const TicketShortInfo: FC<TicketShortInfoProps> = ({ cell, options }) => {
  const { title, id, accountName, accountId } = cell.data.viewData;
  const module = options.module?.toLowerCase();
  return (
    <div className={css.TicketShortInfo}>
      <Text className={css.TicketShortInfo__title} typography="body-long-m">
        {title}
      </Text>
      <div className={css.TicketShortInfo__meta}>
        <Link href={`${getRoutingRoot()}/${module}/${id}`} target="_blank">
          <Text typography="body-long-s" color="secondary">
            {id}
          </Text>
        </Link>
        <Link href={`${getRoutingRoot()}/account/${accountId}`} target="_blank">
          <Text typography="body-long-s" color="secondary">
            {accountName}
          </Text>
        </Link>
      </div>
    </div>
  );
};
