import React, { FC } from 'react';
import { FormattedDate } from 'react-intl';
import { DateTimeCellProps } from './DateTimeCell.types';

export const DateTime: FC<DateTimeCellProps> = (props) => {
  const onlyDate = props.options?.valueType === 'Date';
  const timeSettings = onlyDate
    ? {}
    : { hour: 'numeric' as 'numeric', minute: 'numeric' as 'numeric' };
  return (
    <FormattedDate
      value={new Date(props.cell.data.value)}
      year="numeric"
      month="numeric"
      day="numeric"
      {...timeSettings}
    />
  );
};
