import React, { FC } from 'react';
import { CellType } from '../../../CellType';
import { DateTime } from './DateTime';
import { DateTimeCellProps } from './DateTimeCell.types';
import { themeContext } from '../../../../../themes';

const alignmentByTheme = { mg: 'left', neo: 'left' };

export const DateTimeCell: FC<DateTimeCellProps> = (props) => {
  const theme = React.useContext(themeContext);
  const alignment = alignmentByTheme[theme] || 'right';

  return (
    <CellType alignText={alignment}>
      <DateTime {...props} />
    </CellType>
  );
};
