import React, { FC } from 'react';
import { DiffCellProps } from './DiffCell.types';
import css from './DiffCell.module.css';

export const Diff: FC<DiffCellProps> = ({ cell }) => {
  return (
    <div className={css.DiffCell}>
      <div className={css.DiffCell__row}>
        <span className={css.DiffCell__header}>{cell.data.fieldName}</span>
        {cell.data.oldValue && <span className={css.DiffCell__old}>{cell.data.oldValue}</span>}
        {cell.data.newValue && <span className={css.DiffCell__new}>{cell.data.newValue}</span>}
      </div>
    </div>
  );
};
