import React, { FC, useContext } from 'react';
import { CellType } from '../../../CellType';
import { Digit } from './Digit';
import { DigitCellProps } from './DigitCell.types';
import { themeContext } from '../../../../../themes';

const alignmentByTheme = { clean: 'left' };

export const DigitCell: FC<DigitCellProps> = (props) => {
  const theme = useContext(themeContext);
  const alignment = alignmentByTheme[theme] || 'right';
  return (
    <CellType alignText={alignment}>
      <Digit cell={props.cell} />
    </CellType>
  );
};
