import React, { FC } from 'react';
import LegoLink from '@crm/components/dist/lego2/Link';
import { LinkCellProps } from './LinkCell.types';
import { Text } from '../../../../../Text';
import css from './Link.module.css';

export const Link: FC<LinkCellProps> = (props) => (
  <LegoLink href={props.cell.data.link} target="_blank" rel="noopener">
    <Text className={css.Link__text} text={props.cell.data.text} />
  </LegoLink>
);
