import React, { FC } from 'react';
import { FormattedNumber } from 'react-intl';
import { MoneyCellProps } from './MoneyCell.types';

export const Money: FC<MoneyCellProps> = (props) => {
  const {
    data: { value, currency },
  } = props.cell;
  /* eslint-disable-next-line react/style-prop-object */
  return <FormattedNumber value={value!} style="currency" currency={currency && currency.code} />;
};
