import React, { FC, useContext } from 'react';
import { observer } from 'mobx-react-lite';
import { RowIdContext } from 'components/Table/Row/Row';
import { useEditingService } from 'components/Table/hoc/withEdit/EditingContext';
import Access from 'utils/Access';
import { Overlay } from 'components/Overlay';
import cx from 'classnames';
import css from './RowAction.module.css';
import { RowActionProps } from './RowAction.types';
import { viewComponents } from './views';

export const RowAction: FC<RowActionProps> = observer(({ cell }) => {
  const rowId = useContext(RowIdContext);
  const service = useEditingService();
  const currentEditableRowId = service.actionsManager.getEditingRowId();
  const currentAction = service.actionsManager.getCurrentAction();
  const action = service.actionsManager.getActionById(cell.data.actionId);
  const ViewComponent = action?.viewType && viewComponents[action.viewType];
  if (!ViewComponent) {
    return null;
  }
  const { actionId, actionUrl } = cell.data;
  const disabled = !Access.isEdit(cell.data.access) || service.actionsManager.actionInProgress;

  const handleClick = () => {
    if (!disabled) {
      service.actionsManager.doAction(actionId, rowId, actionUrl);
    }
  };

  const className = cx(css.RowAction, { [css.RowAction_disabled]: disabled });

  return (
    <div className={className}>
      <Overlay
        display={currentEditableRowId === rowId && currentAction?.id === actionId}
        size="xxs"
        zIndex={5}
      />
      <ViewComponent disabled={disabled} className={css.RowAction__button} onClick={handleClick} />
    </div>
  );
});
