import React, { FC } from 'react';
import Icon from '@crm/components/dist/lego2/Icon';
import cx from 'classnames';
import css from './EditButton.module.css';
import { EditButtonProps } from './EditButton.types';

export const EditButton: FC<EditButtonProps> = ({ onClick, className = '' }) => {
  return (
    <div className={cx(className, css.EditButton)} onClick={onClick}>
      <Icon size="m" svg="writeEdit" />
    </div>
  );
};
