import React, { FC } from 'react';
import Icon from '@crm/components/dist/lego2/Icon';
import cx from 'classnames';
import css from './RemoveButton.module.css';
import { RemoveButtonProps } from './RemoveButton.types';

export const RemoveButton: FC<RemoveButtonProps> = ({ onClick, className }) => {
  const classNames = cx(className, css.RemoveButton);

  return (
    <div data-testid="removeRowButton" className={classNames} onClick={onClick}>
      <Icon size="m" svg="mainToolbarDelete" />
    </div>
  );
};
