import React, { FC } from 'react';
import Link from '@crm/components/dist/lego2/Link';
import { Text } from '@crm/components/dist/lego2/Text';
import { Bubble } from 'components/Bubble';
import { TagCellProps } from './TagCell.types';
import css from './Tag.module.css';

export const Tag: FC<TagCellProps> = ({ cell }) => {
  const { name, link, color } = cell.data;
  const body = (
    <Text typography="body-short-m" color="primary">
      {name}
    </Text>
  );
  return (
    <Bubble className={css.Tag} color={`#${color}`}>
      {link ? (
        <Link href={link} target="_blank">
          {body}
        </Link>
      ) : (
        body
      )}
    </Bubble>
  );
};
