import React, { FC } from 'react';
import cx from 'classnames';
import { ExpandText } from 'components/ExpandText';
import { TextareaProps } from './Textarea.types';
import css from './Textarea.module.css';

export const Textarea: FC<TextareaProps> = (props) => {
  const { value, bold } = props.text;

  const className = cx(props.className, css.Text, {
    [css.Text_bold]: bold,
  });

  if (props.withExpand) {
    return <ExpandText {...props} className={className} />;
  }

  return <p className={className}>{value}</p>;
};
