import { ComponentType } from 'react';
import { DigitCell, Digit } from './DigitCell';
import { UserCell, User } from './UserCell';
import { AccountCell, Account } from './AccountCell';
import { CheckboxCell, Checkbox } from './CheckboxCell';
import { DiffCell, Diff } from './DiffCell';
import { CustomViewCell, CustomView } from './CustomViewCell';
import { LinkCell, Link } from './LinkCell';
import { TagCell, Tag } from './TagCell';
import { MoneyCell, Money } from './MoneyCell';
import { PercentCell, Percent } from './PercentCell';
import { TextCell, Text } from './TextCell';
import { TextareaCell, Textarea } from './TextareaCell';
import { ButtonCell, Button } from './ButtonCell';
import { RowActionCell, RowAction } from './RowActionCell';
import { SelectCell, Select } from './SelectCell';
import { SuggestCell, Suggest } from './SuggestCell';
import { DateTimeCell, DateTime } from './DateTimeCell';
import { EmptyCell } from './EmptyCell';
import { UnknownCell } from './UnknownCell';
import { SimpleCellType, CellTypeWithoutInnerPresentation } from '../../../../Table.types';
import { BaseCellProps } from '../../Cell.types';

export const wholeCellComponents: Record<SimpleCellType, ComponentType<BaseCellProps>> = {
  Account: AccountCell,
  User: UserCell,
  Checkbox: CheckboxCell,
  CustomView: CustomViewCell,
  Digit: DigitCell,
  Link: LinkCell,
  Money: MoneyCell,
  Percent: PercentCell,
  Text: TextCell,
  Tag: TagCell,
  Textarea: TextareaCell,
  Empty: EmptyCell,
  Diff: DiffCell,
  Button: ButtonCell,
  RowAction: RowActionCell,
  Select: SelectCell,
  Suggest: SuggestCell,
  DateTime: DateTimeCell,
  Unknown: UnknownCell,
};

export const innerCellComponents: Record<
  Exclude<SimpleCellType, CellTypeWithoutInnerPresentation>,
  ComponentType<BaseCellProps>
> = {
  Account,
  User,
  Checkbox,
  CustomView,
  Digit,
  Link,
  Tag,
  Money,
  Percent,
  Text,
  Diff,
  Button,
  RowAction,
  Select,
  Suggest,
  Textarea,
  DateTime,
};
