import { ComponentType } from 'react';
import * as simple from './Simple';
import { ListCell } from './ListCell';
import { CellType, CellTypeWithoutInnerPresentation } from '../../../Table.types';
import { BaseCellProps } from '../Cell.types';

export const wholeCellComponents: Record<CellType, ComponentType<BaseCellProps>> = {
  ...simple.wholeCellComponents,
  List: ListCell,
};

export const innerCellComponents: Record<
  Exclude<CellType, CellTypeWithoutInnerPresentation>,
  ComponentType<BaseCellProps>
> = {
  ...simple.innerCellComponents,
};
